| Symbol  | Entry           | Exit    | description                                                         | Problem   | syntax                           | validated |
|---------|-----------------|---------|---------------------------------------------------------------------|-----------|----------------------------------|-----------|
| degree  | vertex          | number  | The degree of a vertex is the number of connections (edges) it has. | O(n)      | degree &lt;vertex>               | ✓         |
| dist    | (vertex,vertex) | number  | The distance between two vertices                                   | $O(n^2)$? | dist &lt;vertex> &lt;vertex>     | ✓         |
| temp    | vertex          | number  | temperature of a vertex is $\frac{degree}{n-degree}$                | $O(n)$    | temp &lt;vertex>                 | ✓         |
| rank    | matrix          | number  | the rank of a matrix                                                | $O(n^3)$  | rank &lt;matrix>                 | ✓         |
| weight  | edge            | number  | the weigth of edge is $\frac{1}{\sqrt{degree(u)*degree(v)}} $       | $o(N)$    | weight &lt;vertex> &lt;vertex>   | ✓         |
| IndRand | graph           | number  | Randic Index is the sum of the weights of the edges of a graph      | $O(n^3)$  | IndRand &lt;graphe>              | ✓         |
| rad     | graph           | number  | the radius of graph                                                 | $O(n^3)$  | rad &lt;graphe>                  | ✓         |
| eigen   | matrix          | seq     | the eigenvalue matrix                                               | $O(n^3)$  | eigen &lt;matrix>                | ✓         |
| large   | eigen           | number  | largest eigenvalue                                                  | O(n)      | large &lt;eigen>                 | ✓         |
| large-2 | eigen           | number  | second largest eigenvalue                                           | o(n)      | large-2 &lt;eigen>               | ✓         |
| dia     | graph           | number  | the diameter of a graph                                             | $O(n^3)$  | dia &lt; graph>                  | ✓         |
| max-v   | graph           | nomnbre | the maximum over all vertices                                       | 0(n)      | max-v &lt;graph> &lt; formule>   | ✓         |
| v       | graph           | vertex  | a vertex of graph                                                   | o(1)      | v                                | ✓         |
| u       | graph           | vertex  | a vertex of graph                                                   | o(1)      | u                                | ✓         |
| +       | (number,number) | number  | addition                                                            | o(1)      | + &lt; formule> &lt; formule>    | ✓         |
| -       | (number,number) | number  | subtraction                                                         | o(1)      | - &lt; minuend> &lt; subtrahend> | ✓         |
| ^       | (number,number) | number  | power                                                               | o(1)      | ^&lt; base> &lt; power>          | ✓         |
| *       | (number,number) | number  | multiplication                                                      | o(1)      | * &lt; formule> &lt; formule>    | ✓         |
| /       | (number,number) | number  | division                                                            | o(1)      | /&lt; dividend> &lt; divisor>    | ✓         |
| log     | number          | number  | natural logarithm                                                   | o(1)      | log &lt; formule>                | ✓         |
| sqrt    | number          | number  | square root                                                         | o(1)      | sqrt &lt; formule>               | ✓         |
| max-v-u | graph           | number  | the maximum over all edge                                           | $o(n^2) $ | max-v &lt;graph> &lt; formule>   | ✓         |
| max-v-w | graph           | number  | the maximum over all pairs of vertices (u,v)                        | $o(n^2)$  | max-v &lt;graph> &lt; formule>   | ✓         |
| sum     | seq             | number  | sum of seq                                                          | $o(n)$    | sum &lt; seq >                   | ✓         |
| laplac  | graph           | matrix  | the matrix laplacian of a matrix                                    | $O(n^2)$  | laplac &lt; graph >              | ✓         |

