#include <stdlib.h>
#include <stdio.h>
#include <gmp.h>

struct node {
	int data;
	struct node *next;
};

struct node ** denseDAG(int n)
{
	struct node ** dag = (struct node **)malloc(n*sizeof(struct node *));	

	for(int i=0; i<n-1; i++){
		struct node * tmp1, * tmp2;
		dag[i] = tmp1 = (struct node*)malloc(sizeof(struct node));
		tmp1->data = i+1;
		tmp1->next = NULL;
		for(int j=i+2;j<n;j++){
			tmp2 = (struct node*)malloc(sizeof(struct node));
			tmp2->data = j;
			tmp2->next = NULL;
			tmp1->next = tmp2;
			tmp1 = tmp2;
		}
	}
	dag[n-1]=NULL;
	return dag;
}

struct node ** sparseDAG(int n)
//assume n even
{
	struct node ** dag = (struct node **)malloc(n*sizeof(struct node *));	
	
	//Vertex 0
	dag[0] = (struct node *)malloc(sizeof(struct node));
	dag[0] -> data=1;
	dag[0] -> next = (struct node *)malloc(sizeof(struct node));
	dag[0] -> next -> data=2;
	dag[0] -> next -> next=NULL;

	//Vertices 1..n-2
	for(int i=0; 2*i+2<n; i++){
		for(int j=1; j<=2; j++){
			dag[2*i+j] = (struct node *)malloc(sizeof(struct node));
			dag[2*i+j] -> data = 2*i+3;
			dag[2*i+j] -> next = (struct node *)malloc(sizeof(struct node));
			dag[2*i+j] -> next -> data=2*i+4;
			dag[2*i+j] -> next -> next=NULL;
		}
	}
	dag[n-1]=NULL;

	return dag;
}

int path_count(struct node ** dag, int n)
{
	int *count = (int *)malloc(n*sizeof(int));
	for(int i=0;i<n;i++) count[i]=0;
	count[0]=1;
	for(int i=0;i<n;i++){
		struct node * tmp;
		tmp = dag[i];
		while(tmp){
			count[tmp->data] += count[i];
			count[tmp->data] %= 12345;
			tmp = tmp->next;
		}
	}
	return count[n-1];
}

mpz_t* path_countLong(struct node ** dag, int n)
{
	mpz_t *count = (mpz_t *)malloc(n*sizeof(mpz_t));
	for(int i=0;i<n;i++) mpz_init(count[i]);
	mpz_set_ui(count[0],1);
	for(int i=0;i<n;i++){
		struct node * tmp;
		tmp = dag[i];
		while(tmp){
			mpz_add(count[tmp->data], count[tmp->data], count[i]);
			//count[tmp->data] += count[i];
			tmp = tmp->next;
		}
	}
	return &count[n-1];
}

int main()
{
	int n=12000;
	struct node **dag1 = denseDAG(n);
/*	printf("DAG1:\n");
	for(int i=0; i<n;i++){
		printf("%d: ",i);
		struct node * tmp;
		tmp = dag1[i];
		while(tmp){
			printf("%d ",tmp->data);
			tmp = tmp->next;
		}
		printf("\n");
	}*/
	printf("%s\n", mpz_get_str(NULL,10,*path_countLong(dag1,n)));
}
