import sys
import time

def count_paths(adj):
    pathnum = [ 0 for _ in range (len(adj))]
    pathnum[0]=1
    for i in range(len(adj)):
        for j in adj[i]:
            pathnum[j] += pathnum[i]
    #        pathnum[j] = pathnum[j]%12345
    print(pathnum[len(adj)-1])


def generate_dag_adjacency_list(n):
    adj = [ [] for _ in range (1, n+1) ]

    # Rule 1
    if n >= 2:
        adj[0].append(1)
    if n >= 3:
        adj[0].append(2)

    # Rule 2
    for i in range(1, n//2  -1):
        u1, u2 = 2*i -1, 2*i 
        v1, v2 = 2*i + 1, 2*i + 2

        adj[u1].append(v1)
        adj[u1].append(v2)

        adj[u2].append(v1)
        adj[u2].append(v2)

    adj[n-2].append(n-1)
    adj[n-3].append(n-1)

    return adj

def generate_dag_adjacency_list2(n):
    adj = [ [] for _ in range (1,n+1) ]
    for i in range(0,n-1):
        adj[i] = [ j for j in range(i+1,n)]
    return adj

# Example usage
if __name__ == "__main__":
    #sys.set_int_max_str_digits(100000)
    n = 12000
    dag = generate_dag_adjacency_list2(n)
    start = time.time()
    count_paths(dag)
    print("--- %s seconds ---" % (time.time() - start))

