#include <stdlib.h>
#include <stdio.h>

/* Basic linked list node */
struct node {
	int data;
	struct node *next;
};

/* Returns DAGs of type 1 */
struct node ** sparseDAG(int n)
/* Assume n is a multiple of 3 */
{
	struct node ** dag = (struct node **)malloc(n*sizeof(struct node *));	

	for(int i=0; i<n/3-1; i++){
		for(int j=0; j<3; j++){
			struct node *tmp;
			dag[i+j*(n/3)] = tmp = (struct node*)malloc(sizeof(struct node));
			tmp -> data = i+1;
			tmp -> next = (struct node*)malloc(sizeof(struct node));
			tmp = tmp -> next;
			tmp -> data = i+1+n/3;
			tmp -> next = (struct node*)malloc(sizeof(struct node));
			tmp = tmp -> next;
			tmp -> data = i+1+2*n/3;
			tmp -> next = NULL;
		}
	}
	dag[n/3-1]=dag[2*n/3-1]=dag[n-1]=NULL;
	return dag;
}

/* Returns DAGs of type 2 */
struct node ** denseDAG(int n)
{
	/* A={1,3}
           B={2,5}
           C={0,4}
           D={6} 
	   A->B->C->D*/
	struct node ** dag = (struct node **)malloc(n*sizeof(struct node *));	

	for(int i=0; i<n; i++){
		struct node * tmp1, * tmp2;
		dag[i] = NULL;

		if(i%7 == 1 || i%7 ==3){ /*A*/
			dag[i] = tmp1 = (struct node*)malloc(sizeof(struct node));
			tmp1 -> data = 2;
			tmp1 -> next = NULL;
			for(int j=3; j<n; j++){
				if( j%7!=2 && j%7!=5 ) continue;
				tmp2 = (struct node*)malloc(sizeof(struct node));
				tmp2->data = j;
				tmp2->next = NULL;
				tmp1->next = tmp2;
				tmp1 = tmp2;
			}
		}

		if(i%7 == 2 || i%7 ==5){ /*B*/
			dag[i] = tmp1 = (struct node*)malloc(sizeof(struct node));
			tmp1 -> data = 0;
			tmp1 -> next = NULL;
			for(int j=1; j<n; j++){
				if( j%7!=0 && j%7!=4 ) continue;
				tmp2 = (struct node*)malloc(sizeof(struct node));
				tmp2->data = j;
				tmp2->next = NULL;
				tmp1->next = tmp2;
				tmp1 = tmp2;
			}
		}

		if(i%7 == 0 || i%7 ==4){ /*C*/
			dag[i] = tmp1 = (struct node*)malloc(sizeof(struct node));
			tmp1 -> data = 6;
			tmp1 -> next = NULL;
			for(int j=7; j<n; j++){
				if( j%7!=6 ) continue;
				tmp2 = (struct node*)malloc(sizeof(struct node));
				tmp2->data = j;
				tmp2->next = NULL;
				tmp1->next = tmp2;
				tmp1 = tmp2;
			}
		}
	}

	return dag;
}

int * topo_sort_naive(struct node **dag, int n)
/* Complexity: O(n^2m) !! */
{
	int *active = (int *) malloc(n*sizeof(int));
	int *rank = (int *) malloc(n*sizeof(int));
	for(int i=0; i<n; i++) active[i]=1;

	int curr=0;
	while(curr<n){
		for(int i=0;i<n;i++){
			if(active[i]==0) continue;
			/* check if i is a source */
			int flag;
			flag = 1;

			for(int j=0; j<n; j++){
				if(active[j]==0) continue;

				/* check arc from j to i */
				struct node * tmp = dag[j];
				while(tmp){
					if(tmp->data == i){ flag=0; break;}
					tmp = tmp->next;
				}
			}
			if(flag==0){ continue; }
			rank[i] = curr;
			curr++;
			active[i]=0;
			break;
		}
	}
	free(active);
	return rank;
}

int * topo_sort_degrees(struct node **dag, int n)
/* Repeatedly finds a source, removes it, updates indegrees of other vertices */
/* Complexity: O(n+m) */
/* Uses a quick and dirty queue (via an array) */
{
	int *rank = (int*)malloc(n*sizeof(int));
	int *indegs = (int *)malloc(n*sizeof(int));

	for(int i=0;i<n;i++) indegs[i]=0;

	/* initialize indegrees */
	for(int i=0; i<n ; i++){
		struct node * tmp;
		tmp = dag[i];
		while(tmp){
			indegs[tmp->data]++;
			tmp = tmp->next;
		}
	}

	int *myq = (int *)malloc(n*sizeof(int));
	int first=0, last=0;

	/* Add all sources to queue */
	for(int i=0; i<n; i++){
		if(indegs[i]==0)
			myq[last++]=i;
	}
	
	int cur=0;
	while(first<last){
		rank[myq[first]] = cur++;
		struct node *tmp = dag[ myq[first] ];
		while(tmp){
			indegs[tmp->data]--;
			if(indegs[tmp->data]==0){
				myq[last++]=tmp->data;
			}
			tmp = tmp->next;
		}
		first++;
	}
	free(myq);
	free(indegs);
	return rank;
}

void dfs_visit(struct node**dag, int n, int i, int*color, int *cur, int *rank)
/* Basic DFS function
   i: current vertex
   color: array with colors, 0=white, 1=gray, 2=black
   cur: int reference to current time variable (we only increase when a vertex turns Black)
   rank: array with computed ranks */
{
	color[i] = 1;
	struct node*tmp = dag[i];
	while(tmp){
		if(color[tmp->data]==0) dfs_visit(dag,n,tmp->data,color,cur,rank);
		tmp = tmp->next;
	}	
	color[i] = 2;
	rank[i] = *cur;
	(*cur)--;
}


int *dfs_sort(struct node **dag, int n)
/* DFS, initialize data and call previous function in a loop */
{
	int *color = (int*)malloc(n*sizeof(int));
	int *rank =  (int*)malloc(n*sizeof(int));
	int cur = n-1;
	for(int i=0;i<n;i++) color[i]=0;

	for(int i=0;i<n;i++){
		if(color[i]==0){
			dfs_visit(dag,n,i,color,&cur,rank);
		}
	}

	free(color);
	return rank;
}

int *sort_by_rank(int *rank, int n)
/* allows to obtain a sorted list of vertices from their ranks */
{
	int *sorted = (int *)malloc(n*sizeof(int));
	for(int i=0;i<n;i++){
		sorted[rank[i]] = i;
	}
	return sorted;
}

void check_ranks(struct node **dag, int n, int *rank)
/* Check that rank array is a permutation and that arcs are compatible with ranking */
{
	/* check that we have a permutation */
	int *freq = (int *)malloc(n*sizeof(int));
	for(int i=0;i<n;i++) freq[i]=0;
	for(int i=0;i<n;i++) freq[rank[i]]++;
	for(int i=0;i<n;i++){
		if(freq[i]!=1){
			printf("Not a permutation!");
			free(freq);
			return;
		}
	}

	/* check all arcs are OK */
	for(int i=0;i<n;i++){
		struct node*tmp;
		tmp = dag[i];
		while(tmp){
			if(rank[i]>rank[tmp->data]){
				printf("arc %d->%d violated!\n",i,tmp->data);
			}
		tmp = tmp->next;
		}
	}
	printf("Looks OK\n");
}


int main()
{
	int n=4000000;
	struct node **dag1 = sparseDAG(n); // or = sparseDAG(n);
// Uncomment to print the adjacency lists
/*	printf("DAG1:\n");
	for(int i=0; i<n;i++){
		printf("%d: ",i);
		struct node * tmp;
		tmp = dag1[i];
		while(tmp){
			printf("%d ",tmp->data);
			tmp = tmp->next;
		}
		printf("\n");
	}*/
	int *rank;
	int *sorted;
	//rank = topo_sort_naive(dag1,n);
	//check_ranks(dag1,n,rank);
	
	//Uncomment to print ranks computed by naive algorithm
	/*for(int i=0; i<n; i++){
		printf("rank[%d]=%d\n",i,rank[i]);
	}*/

	//Uncomment to print ordering computed by naive algorithm
	//printf("Sorted order\n");
	//sorted = sort_by_rank(rank, n);
	//for(int i=0; i<n; i++){
	//	printf("%d, ",sorted[i]);
	//}
	//printf("\n");

	//rank = topo_sort_degrees(dag1,n);
	//sorted = sort_by_rank(rank, n);
	//check_ranks(dag1,n,rank);

	//printf("Sorted order\n");
	
	
	//for(int i=0; i<n; i++){
	//	printf("%d, ",sorted[i]);
	//}
	//printf("\n");

	rank = dfs_sort(dag1,n);
	sorted = sort_by_rank(rank, n);
	//check_ranks(dag1,n,rank);

/*	printf("Sorted order\n");
	for(int i=0; i<n; i++){
		printf("%d, ",sorted[i]);
	}
	printf("\n");*/

}

