#include <stdlib.h>
#include <stdio.h>

/* Basic linked list node */
struct node {
	int data;
	struct node *next;
};

struct node ** gaber_galil(int n)
{
	int N = n*n;
	struct node **gg = (struct node **)malloc(N*sizeof(struct node *));
	struct node *tmp;
	for(int i=0; i<n; i++)
		for(int j=0; j<n; j++){
		/* Node (i,j) is node i*n+j */

		/* (x,y) -> (x+1,y) */
		tmp = (struct node*)malloc(sizeof(struct node));
		gg[i*n+j] = tmp; 
		tmp->data = ((i+1)%n)*n+j;
		
		/* (x,y) -> (x-1,y) */
		tmp->next =  (struct node*)malloc(sizeof(struct node));
		tmp = tmp->next;
		tmp->data = ((i+n-1)%n)*n+j;

		/* (x,y) -> (x,y+1) */
		tmp->next =  (struct node*)malloc(sizeof(struct node));
		tmp = tmp->next;
		tmp->data = i*n+((j+1)%n);

		/* (x,y) -> (x,y-1) */
		tmp->next =  (struct node*)malloc(sizeof(struct node));
		tmp = tmp->next;
		tmp->data = i*n+((j+n-1)%n);

		/* (x,y) -> (x+y,y) */
		tmp->next =  (struct node*)malloc(sizeof(struct node));
		tmp = tmp->next;
		tmp->data = ((i+j)%n)*n+j;

		/* (x,y) -> (x,x+y) */
		tmp->next =  (struct node*)malloc(sizeof(struct node));
		tmp = tmp->next;
		tmp->data = i*n+((i+j)%n);

		/* (x,y) -> (x-y,y) */
		tmp->next =  (struct node*)malloc(sizeof(struct node));
		tmp = tmp->next;
		tmp->data = ((i-j+n)%n)*n+j;

		/* (x,y) -> (x,y-x) */
		tmp->next =  (struct node*)malloc(sizeof(struct node));
		tmp = tmp->next;
		tmp->data = i*n+((j-i+n)%n);

		tmp->next = NULL;
	} 

	return gg;
}

int *bfs(struct node **g, int n)
/*Returns distance array, starts BFS from 0*/
{
	int *dist = (int *)malloc(n*sizeof(int));
	/* Initialize distances to -1. This allows to avoid using colors (White <-> dist==-1) */
	for(int i=0; i<n; i++) dist[i]=-1;
	
	int *q =  (int *)malloc(n*sizeof(int));
	int first = 0, last = 0;
	q[0] = 0;
	dist[0] = 0;
	while(last-first>=0){
		int cur=q[first++];
		struct node *tmp;
		tmp = g[cur];
		while(tmp){
			if(dist[tmp->data]==-1){
				last++;
				q[last]=tmp->data;
				dist[tmp->data]=dist[cur]+1;
			}
			tmp = tmp->next;
		}
	}
	free(q);
	return dist;
}

int main(int argc, char **argv)
{
	int n=100;
	if(argc==2) n=atoi(argv[1]);
	struct node **gg = gaber_galil(n);
/*	for(int i=0; i<n; i++)
		for(int j=0; j<n; j++){
		printf("(%d, %d): ",i,j);
		struct node*tmp = gg[i*n+j];
		while(tmp){
			printf("(%d,%d), ", tmp->data/n, tmp->data%n);
			tmp = tmp->next;
		}
		printf("\n");
	}*/

	int *dist = bfs(gg,n*n);
/*	printf("Distances\n");
	for(int i=0; i<n; i++)
		for(int j=0; j<n; j++){
			printf("(%d, %d): %d\n",i,j,dist[i*n+j]);
	}*/
	int max = 0;
	for(int i=0; i<n*n; i++) if(dist[i]>max) max = dist[i];
	printf("For n=%d, N=%d, max distance is %d\n",n,n*n,max);
}
