public class Rational{
	private int x,y;
	public Rational(int x, int y){ this.x=x; this.y=y; if(y==0) System.out.println("error!");}
	public Rational(int p){ this(p,1); }
	private static int pgcd(int a, int b){
		a = a<0 ? -a: a;
		b = b<0 ? -b: b;
		if(a==0 || b==0) return a+b;
		while(a!=b){
			if(a>b) a = a-b;
			if(b>a) b = b-a;
		}
		return a;
	}
	public Rational simplify(){
		return new Rational(x/pgcd(x,y),y/pgcd(x,y));
	}

	public String toString(){
		return "("+x+"/"+y+")";
	}

	public Rational add(Rational r){
		return new Rational(x*r.y+y*r.x,y*r.y).simplify();
	}

	public Rational mult(Rational r){
		return new Rational(x*r.x,y*r.y).simplify();
	}

	public Rational inv(){
		return new Rational(y,x);
	}

	public Rational add(int r){
		return add(new Rational(r));
	}

	public Rational mult(int r){
		return mult(new Rational(r));
	}

	public Rational div(Rational r) { return mult(r.inv()); }

	public Rational sub(Rational r) { return add(r.mult(new Rational(-1))); }

	public double toDouble() { return ((double)x)/y; }
}
